/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.info;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PlanetInfo
extends CelestialBody {
    private final long orbitDuration;
    public final CelestialBody orbitCenter;
    public final double orbitRadius;
    public double currentAngle;
    public boolean spaceStation = false;
    public boolean canLaunchOn = true;
    public static final Codec<PlanetInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(b -> b.texture), (App)Codec.STRING.fieldOf("name").forGetter(b -> b.name), (App)Codec.DOUBLE.fieldOf("orbitRadius").forGetter(b -> b.orbitRadius), (App)Codec.LONG.fieldOf("orbitDuration").forGetter(b -> b.orbitDuration), (App)Codec.FLOAT.fieldOf("width").forGetter(b -> Float.valueOf(b.width)), (App)Codec.FLOAT.fieldOf("height").forGetter(b -> Float.valueOf(b.height)), (App)CelestialBody.CODEC.fieldOf("orbitCenter").forGetter(b -> b.orbitCenter), (App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(b -> b.dimension), (App)Codec.STRING.fieldOf("translatable").forGetter(b -> b.translatable), (App)Codec.STRING.fieldOf("id").forGetter(b -> b.id), (App)Codec.BOOL.optionalFieldOf("space_station", (Object)false).forGetter(b -> b.spaceStation), (App)Codec.BOOL.optionalFieldOf("can_launch_on", (Object)true).forGetter(b -> b.canLaunchOn)).apply((Applicative)instance, PlanetInfo::new));

    public PlanetInfo(ResourceLocation texture, String name, double orbitRadius, long orbitDuration, float width, float height, CelestialBody orbitCenter, ResourceKey<Level> dimension, Component translatable, String id, boolean spaceStation, boolean canLaunchOn) {
        this(texture, name, orbitRadius, orbitDuration, width, height, orbitCenter, dimension.location(), translatable.getString(), id, spaceStation, canLaunchOn);
    }

    public PlanetInfo(ResourceLocation texture, String name, double orbitRadius, long orbitDuration, float width, float height, CelestialBody orbitCenter, ResourceLocation dimension, String translatable, String id, boolean spaceStation, boolean canLaunchOn) {
        super(texture, name, 0.0f, 0.0f, width, height, 0xFFFFFF, dimension, translatable, id);
        this.orbitRadius = orbitRadius;
        this.orbitDuration = orbitDuration;
        this.orbitCenter = orbitCenter;
        this.currentAngle = 0.0;
        this.translatable = translatable;
        this.id = id;
    }

    public double updateAngle(long currentTime) {
        double orbitProgress = (double)(currentTime % this.orbitDuration) / (double)this.orbitDuration;
        this.currentAngle = orbitProgress * 2.0 * Math.PI;
        return this.currentAngle;
    }

    public void updatePosition() {
        this.x = (float)((double)this.orbitCenter.x + this.orbitRadius * Math.cos(this.currentAngle));
        this.y = (float)((double)this.orbitCenter.y + this.orbitRadius * Math.sin(this.currentAngle));
    }

    public long getOrbitDuration() {
        return this.orbitDuration;
    }
}

